package com.iesms.openservices.photovoltaic.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 分布式光伏-->运行维护--清洗记录管理
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PvStationDevCleanRecordDto implements Serializable {

    /**
     * 设备标识
     */
    private String devId;

    /**
     * 用能点id
     */
    private String pointId;

    /**
     * 量测点集合
     */
    private String measPointIdList;

    /**
     * 设备编号
     */
    private String devNo;

    /**
     * 设备通讯地址码
     */
    private String commonAddressNo;

    /**
     * 设备名称
     */
    private String ceResName;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 清洗开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String cleanStartTime;

    /**
     * 曲线上送时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String givingDate;

    /**
     * 任务方式（1 - 自动；2 - 手动 ）
     */
    private int taskMode;

    /**
     * 任务方式（1 - 自动；2 - 手动 ）
     */
    private String taskModeName;

    /**
     * 主电流信息
     */
    private String mainCurrent;

    /**
     * 从电流信息
     */
    private String flowCurrent;

}
