package com.iesms.openservices.photovoltaic.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 分布式光伏-->运行维护--智能清洗设备概况
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PvStationDevSurveyDto implements Serializable {

    /**
     * 用户标识
     */
    private String ceCustId;

    /**
     * 设备标识
     */
    private String devId;

    /**
     * 设备通讯地址码
     */
    private String commonAddressNo;

    private String manufacturer;

    /**
     * 设备编号用于下发参数
     */
    private String ceResNo;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 所属运营商
     */
    private String orgName;

    /**
     * 用户地址
     */
    private String ceCustAddr;

    /**
     * 机器人数量
     */
    private int robotCount;

    /**
     * 单电机数量
     */
    private int robotCount1;

    /**
     * 多电机数量
     */
    private int robotCount2;

    /**
     * 离线数量
     */
    private int offlineCount;

    /**
     * 离线率
     */
    private BigDecimal offlineRate;

    /**
     * 故障数量
     */
    private int faultCount;

    /**
     * 故障率
     */
    private BigDecimal faultRate;

    /**
     * 设备编号
     */
    private String devNo;

    /**
     * 设备名称
     */
    private String ceResName;

    /**
     * 电机类型：1 - 单电机；2 - 多电机
     */
    private String motorType;

    /**
     * 设备状态（0-启用   1—停用）
     */
    private String runningStatus;

    /**
     * 通信状态（0-离线   1-在线）
     */
    private String communicateStatus;

    /**
     * 电池状态（0-正常  1-过放  2-欠压）
     */
    private String batteryCondition;

    /**
     * 蓄电池电压
     */
    private String batteryVoltage;

    /**
     * 蓄电池电流
     */
    private String batteryCurrent;

    /**
     * 蓄电池温度
     */
    private String batteryTemperature;

    /**
     * 蓄电池剩余电量
     */
    private String remainingBatteryPower;

    /**
     * 是否故障 0 - 未故障  1 - 故障
     */
    private String isFault;

    /**
     * 是否故障 0 - 未故障  1 - 故障
     */
    private String isFaultNo;

    /**
     * 告警事件标识
     */
    private String soeObjectId;

    /**
     * 告警名称
     */
    private String soeObjectName;

    /**
     * 告警详情
     */
    private String soeDesc;

    /**
     * 告警时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String soeGenTime;

    /**
     * 异常告警消息列表
     */
    private List<PvStationDevSurveyDto> getFaultInfoList;

    /**
     * 机器人列表
     */
    private List<PvStationDevSurveyDto> devNameList;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;



}
