package com.iesms.openservices.photovoltaic.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分布式光伏-->首页返回值实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-13
 */
@Data
public class PvStationMainDto implements Serializable {

    /**
     * 区域编码
     */
    private String adCode;

    /**
     * 区域名称
     */
    private String adName;

    /**
     * 装机容量
     */
    private BigDecimal totalCapacity;

    /**
     * 电站个数
     */
    private int stationTotal;

    /**
     * 集中式光伏电站计划完成装机容量
     */
    private BigDecimal planCapacity;

    /**
     * 分布式光伏电站计划完成装机容量
     */
    private BigDecimal distributionPlanCapacity;

    /**
     * 装机容量排名
     */
    private int capacityRanking;

    /**
     * 区域装机容量占比
     */
    private BigDecimal capacityProp;

    /**
     * 月发电量
     */
    private BigDecimal egenValueMonth;

    /**
     * 自发自用电量
     */
    private BigDecimal egenSelfUseValueMonth;

    /**
     * 月份日期
     */
    private String monthStat;

    /**
     * 柱状图中展示的补贴金额
     */
    private BigDecimal moneySubsidyTotal;

    /**
     * 自发自用电量
     */
    private BigDecimal egenSelfUseValue;

    /**
     * 发电量
     */
    private BigDecimal egenValue;

    /**
     * 总的年自发自用电量
     */
    private BigDecimal egenSelfUseValueYearSum;

    /**
     * 总的年发电量
     */
    private BigDecimal egenValueYearSum;

    /**
     * 总的年收益总额
     */
    private BigDecimal pvProfitTotalYear;

    /**
     * 总的年节标准煤量
     */
    private BigDecimal sscqValueYearSum;

    /**
     * 总的年减二氧化碳排放量
     */
    private BigDecimal scdeValueYearSum;

    /**
     * 总的年减二氧化硫排放量
     */
    private BigDecimal ssdeValueYearSum;

    /**
     * 总的年减森林砍伐面积
     */
    private BigDecimal sdaValueYearSum;

    /**
     * 日平均有效发电小时数
     */
    private BigDecimal eqHoursAvg;

    /**
     * 当月累计补贴金额
     */
    private BigDecimal moneySubsidyTotalMonthSum;

    /**
     * 当年累计补贴金额
     */
    private BigDecimal moneySubsidyTotalYearSum;

    /**
     * 总累计补贴金额
     */
    private BigDecimal moneySubsidyTotalAccum;

    /**
     * 曲线日期
     */
    private String dateStat;

}
