package com.iesms.openservices.photovoltaic.entity;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分布式光伏-->运行维护--参考单位信息
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PvStationRefDevInfoDto implements Serializable {

    /**
     * 一级系统单位编号
     */
    private String primaryOrgNo;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 样本id
     */
    private String sampleId;

    /**
     * 所选设备标识
     */
    private String deviceId;

    /**
     * 所选设备名称（样本名称）
     */
    private String deviceName;

    /**
     * 上级对象名称
     */
    private String parentCeResName;

    /**
     * 用户id
     */
    private String ceCustId;

    /**
     * 所属电站（用户名称）
     */
    private String ceCustName;

    /**
     * 所属运营商名称
     */
    private String orgName;

    /**
     * 投运日期
     */
    private String operationDate;

    /**
     * 装机容量
     */
    private BigDecimal elecCapacity;

    /**
     * 用能资源分类编号（DEV_PV_INVERTER -- 逆变器；DEV_PV_INVERTER_PVCIRCUIT -- 逆变器PV回路；DEV_PV_INVERTER_GROUPLIST -- 逆变器组串）
     */
    private String ceResSortNo;

    /**
     * 逆变器组串数量
     */
    private BigDecimal moduleCount;

    /**
     * 逆变器组串的输出功率
     */
    private BigDecimal outPutPower;

    /**
     * 当前功率
     */
    private String currentPower;

    /**
     * 样本说明
     */
    private String sampleDesc;

}
