package com.iesms.openservices.photovoltaic.entity;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分布式光伏-->运行维护--参考单元设置返回值
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PvStationReferenceUnitSettingDto implements Serializable {

    /**
     * 样本id
     */
    private String sampleId;

    /**
     * 用户标识
     */
    private String ceCustId;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 用户地址
     */
    private String ceCustAddr;

    /**
     * 样本类型
     */
    private String sampleType;

    /**
     * 样本名称
     */
    private String sampleName;

    /**
     * 装机容量
     */
    private BigDecimal elecCapacity;

    /**
     * 样本说明
     */
    private String sampleDesc;

    /**
     * 是否有参考单元 0 - 否；1 - 是
     */
    private String isReferenceUnit;
}
