package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import com.iesms.openservices.photovoltaic.common.IesmsNormalEntity;
import com.iesms.openservices.photovoltaic.enums.PvUavStatusEnum;
import com.iesms.openservices.photovoltaic.jsonobject.PvUavInsuranceDetailJsonObject;
import com.iesms.openservices.photovoltaic.typehandler.JsonObjectTypeHandler;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 大有无人机
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/12/21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class PvUav extends IesmsNormalEntity {

    private static final long serialVersionUID = -3401636416293414717L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 无人机编号
     */
    private String uavNo;

    /**
     * 无人机型号
     */
    private String uavModel;

    /**
     * 出厂日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date initDate;

    /**
     * 生产厂家
     */
    private String manufacturer;

    /**
     * 保险开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuranceStartTime;

    /**
     * 保险截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuranceEndTime;

    /**
     * 保险总额度
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal insuranceLimitMoney;

    /**
     * 剩余保险金额
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal residueInsuranceMoney;

    /**
     * 出险记录详情
     */
    @TableField(typeHandler = JsonObjectTypeHandler.class)
    private PvUavInsuranceDetailJsonObject insuranceDetail;

    /**
     * 无人机状态
     */
    private String uavStatus;

    /**
     * 是否共享
     */
    private Boolean isShare;

    /**
     * 附件
     */
    private String attach;

    /**
     * 序列号
     */
    private String mondevSerialNo;

    /**
     * 通道号
     */
    private String mondevChannelNo;
}
