package com.iesms.openservices.photovoltaic.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2021/11/30 19:41
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class RealtimeWorkingConditionVo {

    /**
     * 区域id
     */
    private Long cePartId;
    /**
     * 设备id
     */
    private Long ceDeviceId;
    /**
     * 量测点标识
     */
    private Long measPointId;
    /**
     * 装机容量
     */
    private BigDecimal installCapacity;
    /**
     * 额定功率
     */
    private BigDecimal ratedPower;
    /**
     * 设备数
     */
    private Integer powerInverterDeviceCount;
}
