package com.iesms.openservices.photovoltaic.entity;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @param
 * @ClassName RobotOperatingCondition
 * @Description TODO  机器人工况  实体类
 * @Author zhouyi
 * @Data 2021/10/18 13:56
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class RobotOperatingCondition implements Serializable {
    private static final long serialVersionUID = -1065141049713275591L;
    /***
    *主键id
    */
   private Long id;

    /***
     *设备id
     */
   private Long deviceId;

    /***
     *运行状态
     */
    private int runningStatus;

    /***
     *通信状态
     */
    private int communicateStatus;

    /***
     *电池状态
     */
    private int batteryCondition;

    /***
     *蓄电池电压
     */
    private String batteryVoltage;
    /***
     *蓄电池温度
     */
    private String batteryTemperature;
    /***
     *蓄电池剩余电量
     */
    private String remainingBatteryPower;
    /***
     *蓄电池电流
     */
    private String batteryCurrent;

    /***
     *是否故障
     */
    private  int isFault;
    /***
     *其他参数
     */
    private String reportParams;


}
