package com.iesms.openservices.photovoltaic.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author Lin yicheng
 * @date 2022/1/19 11:15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class SchemeTrackVo {

    /**
     * 日期
     */
    private String Date;

    /**
     * 方案Id
     */
    private Long schemeId;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     * 计划起始时间
     */
    private String plannedStartTime;

    /**
     * 计划结束时间
     */
    private String plannedEndTime;

    /**
     * 实际开始时间
     */
    private String actualStartTime;

    /**
     * 实际结束时间
     */
    private String actualEndTime;

    /**
     * 充放电开始时间
     */
    private String startTime;

    /**
     * 充放电结束时间
     */
    private String endTime;

    /**
     * 功率
     */
    private BigDecimal power;

}
