package com.iesms.openservices.photovoltaic.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;

/**
 * @param
 * @ClassName StoredEnergyCustDto
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/12/3 10:47
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@SuperBuilder
public class StoredEnergyCustDto  extends StoredEnergyCust{

    /***
     * 客户id
     */
   private Long ceCustId;
    /***
     * 储能户号
     */
    private String storedEnergyNo;

    /***
     * 储能户名
     */
    private String storedEnergyName;

    /***
     * 额定功率
     */
    private String ratedPower;

    /***
     * 地址
     */
    private String ceCustAddr;

    /***
     * 运行状态
     */
    private String runningStatus;

    /***
     * 地址
     */
    private String totalSoc;



    /***
     * 月充电量
     */
    private BigDecimal rechargeEconsMonth;


    /***
     * 月放电量
     */
    private BigDecimal dischargeEconsMonth;


    /***
     * 年充电量
     */
    private BigDecimal rechargeEconsYear;


    /***
     * 年放电量
     */
    private BigDecimal dischargeEconsYear;
}
