package com.iesms.openservices.photovoltaic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 温州用户导入表
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-12-10
 */
@Data
@Accessors(chain = true)
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@TableName(autoResultMap = true)
public class TestWzImportUser implements Serializable {

    /**
     * 客户id
     */
    private Long ceCustId;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 户号
     */
    private String ceResNo;

    /**
     * 户名
     */
    private String ceResName;

    /**
     * 用户地址
     */
    private String ceResAddr;

    /**
     * 用电分类
     */
    private String consElecSort;

    /**
     * 用电性质
     */
    private String consElecProp;

    /**
     * 行业分类
     */
    private String tradeCode;

    /**
     * 电压等级
     */
    private String voltageClass;

    /**
     * 合同容量
     */
    private String contractCapacity;

    /**
     * 立户日期
     */
    private Date openCustDate;

    /**
     * 抄表例日
     */
    private String consElecReadingDay;

    /**
     * 缴费方式
     */
    private String payType;

    /**
     * 用能点id（编号）
     */
    private String cePointNo;

    /**
     * 用能点名称
     */
    private String cePointName;

    /**
     * 模板名称
     */
    private Long tmplId;

    /**
     * 发电户号
     */
    private String electricityNo;

    /**
     * 发电户名
     */
    private String electricityName;

    /**
     * 电站分类
     */
    private String pvClassification;

    /**
     * 并网类型
     */
    private String pvNetType;

    /**
     * 装机容量
     */
    private String installCapacity;

    /**
     * 并网电压等级
     */
    private String pvVolatageClass;

    /**
     * 并网对象
     */
    private String pvNetObj;

    /**
     * 电站类型
     */
    private String pvType;

    /**
     * 建筑类型
     */
    private String buildingType;

    /**
     * 立户日期
     */
    private Date custDate;

    /**
     * 投运日期
     */
    private Date parallelDate;

    /**
     * 光伏重点项目
     */
    private String importantProject;

    /**
     * 投资模式
     */
    private String inveModel;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 城市编码
     */
    private String citycode;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 低压地理位置区域的id
     */
    private String distNeighborhoodResourceId;
}
