package com.iesms.openservices.photovoltaic.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 忠县首页--实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-11-26
 */
@Data
public class ZXHomePageDto implements Serializable {

    /**
     * 当日发电量
     */
    private BigDecimal egenValueDay;

    /**
     * 当月发电量
     */
    private BigDecimal egenValueMonth;

    /**
     * 当年发电量
     */
    private BigDecimal egenValueYear;

    /**
     * 累计发电量
     */
    private BigDecimal egenValueAccum;

    /**
     * 当日充电量
     */
    private BigDecimal rechargeEconsDay;

    /**
     * 当日放电量
     */
    private BigDecimal dischargeEconsDay;

    /**
     * 累计充电量
     */
    private BigDecimal rechargeEconsYearSum;

    /**
     * 累计放电量
     */
    private BigDecimal dischargeEconsYearSum;

    /**
     * 装机容量
     */
    private BigDecimal totalCapacity;

    /**
     * 标准煤量
     */
    private BigDecimal sscqValue;

    /**
     * 减二氧化碳排放量
     */
    private BigDecimal scdeValue;


}
