package com.iesms.openservices.photovoltaic.entity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liumu
 * @date 2021-11-29 11:05
 * 忠县储能 - 补贴方案
 */
@Data
public class ZxSubsidyScheme implements Serializable {

    private static final long serialVersionUID = -8506682046308019602L;

    /**
     * SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 补贴方案编号
     */
    private String schemeNo;

    /**
     * 补贴方案名称
     */
    private String schemeName;

    /**
     * 国家补贴单价;元/kWh
     */
    private String subsidyPriceCountry;

    /**
     * 省补贴单价;元/kWh
     */
    private String subsidyPriceProvince;

    /**
     * 市补贴单价;元/kWh
     */
    private String subsidyPriceCity;

    /**
     * 区县补贴单价;元/kWh
     */
    private String subsidyPriceDistrict;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 是否有效
     */
    private Boolean isValid;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;

    /**
     * 失效时间;为0表示为空
     */
    private Long gmtInvalid;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;
}
