package com.iesms.openservices.photovoltaic.enums;

import com.iesms.openservices.photovoltaic.common.IBaseCodeEnum;
import lombok.Getter;

/**
 * 电网资源分类编号
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Getter
public enum GridResSortNoEnum implements IBaseCodeEnum<String> {

    /**
     * SUBSTATION - 变电站
     */
    SUBSTATION("SUBSTATION", "变电站"),

    /**
     * POWERLINE - 线路
     */
    NETWORK("POWERLINE", "线路"),

    /**
     * TRANS_PUBLIC - 公变
     */
    LOAD("TRANS_PUBLIC", "公变"),

    /**
     * TRANS_SPECIAL - 专变
     */
    STORAGE("TRANS_SPECIAL", "专变");

    private final String value;
    private final String name;

    GridResSortNoEnum(final String value, final String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }
}
