package com.iesms.openservices.photovoltaic.enums;

import com.iesms.openservices.photovoltaic.common.IBaseCodeEnum;
import lombok.Getter;

/**
 * 电网资源状态
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Getter
public enum GridResStatusEnum implements IBaseCodeEnum<Integer> {

    /**
     * INITIAL
     * 1 - 初始
     */
    INITIAL(1, "初始"),

    /**
     * WAITFOR_RUN
     * 2 - 待运
     */
    WAITFOR_RUN(2, "待运"),

    /**
     * GOTO_RUN
     * 3 - 运行
     */
    GOTO_RUN(3, "运行"),

    /**
     * PAUSE_RUN
     * 4 - 暂停
     */
    PAUSE_RUN(4, "暂停"),

    /**
     * STOP_RUN
     * 9 - 退运
     */
    STOP_RUN(9, "退运");

    private final Integer value;
    private final String name;

    GridResStatusEnum(final Integer value, final String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }
}
