package com.iesms.openservices.photovoltaic.enums;

import com.iesms.openservices.photovoltaic.common.IBaseCodeEnum;
import lombok.Getter;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Getter
public enum IsDeletedEnum implements IBaseCodeEnum<Integer> {

    /**
     * NOT_DELETE
     * 1 - 未删除
     */
    NOT_DELETE(1, "未删除"),

    /**
     * IS_DELETED
     * 0 - 已删除
     */
    IS_DELETED(0, "已删除");

    private final Integer value;
    private final String name;

    IsDeletedEnum(final Integer value, final String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }

}
