package com.iesms.openservices.photovoltaic.enums;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.iesms.openservices.photovoltaic.common.IBaseCodeEnum;
import lombok.Getter;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum PvUavStatusEnum implements IBaseCodeEnum<String> {

    /**
     * 执行任务中
     */
    EXECUTION("1", "执行任务中"),

    /**
     * 待机
     */
    AWAIT("2", "待机"),

    /**
     * 退役
     */
    RETIREMENT("3", "退役"),

    /**
     * 报废
     */
    ABANDON("4", "报废"),

    /**
     * 其他
     */
    OTHER("5", "其他");

    private final String value;
    private final String name;

    PvUavStatusEnum(final String value, final String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }

    public static PvUavStatusEnum getByValue(String value) {
        for (PvUavStatusEnum e : values()) {
            if (StrUtil.equals(e.getValue(), value)) {
                return e;
            }
        }
        return PvUavStatusEnum.OTHER;
    }
}
