package com.iesms.openservices.photovoltaic.jsonobject;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2023/5/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Accessors(chain = true)
public class DayouWordOrderOtherInfoJsonObject implements Serializable {

    /**
     * 结果
     */
    private String result;

    /**
     * 描述
     */
    private String description;

    /**
     * 关联工单
     */
    private String relevancyWorkOder;

    /**
     * 原因
     */
    private String reason;

    /**
     * 工作量
     */
    private String workload;

    /**
     * 预估损失发电量
     */
    private String lossElectric;

    /**
     * 故障时效
     */
    private String faultHour;

    /**
     * 累计故障时间
     */
    private String faultTimeAccum;

    /**
     * 缺陷等级
     */
    private String faultLevel;

    /**
     * 异常明细
     */
    private String exceptionDetail;

    /**
     * 异常巡检数量
     */
    private String exceptionInspectionCount;

    /**
     * 关联图片
     */
    private List<String> imageList;
}
