package com.iesms.openservices.photovoltaic.jsonobject;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 可调资源属性
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GridResourceAdjustableResourceAttrJsonObject implements Serializable {

    private static final long serialVersionUID = -3165045039673618301L;

    /**
     * 调峰电站 & 分布式电站 & 负荷用户 & 负荷聚合商 & 储能电站
     * 可调资源数
     */
    private Integer adjustableResourcesCount;

    /**
     * 调峰电站 & 分布式电站 & 负荷用户 & 负荷聚合商 & 储能电站
     * 设计可调节能力值
     *      调峰电站：设计可调装机容量（单位：kW）
     *      负荷用户：设计可调负荷（单位：kW）
     *      储能电站：设计可调最大输出功率（单位：kW）
     */
    private BigDecimal designAdjustableCapacity;

    /**
     * 储能电站
     *      设计可调储能容量（单位：kWh）
     */
    private BigDecimal designAdjustableStorageCapacity;

    /**
     * 变电站 & 线路
     * 设计容量（单位：kVA）
     */
    private BigDecimal networkDesignCapacity;

    /**
     * 变电站 & 线路
     * 计划扩容（单位：kVA）
     */
    private BigDecimal networkPlanCapacity;

    /**
     * 变电站
     * 设计间隔数（单位：个）
     */
    private Integer substationDesignIntervalCount;

    /**
     * 变电站
     * 当前空余间隔数（单位：个）
     */
    private Integer substationSpareIntervalCount;

    /**
     * 变电站
     * 当前空余间隔容量（单位：kVA）
     */
    private BigDecimal substationSpareIntervalCapacity;
}
