package com.iesms.openservices.photovoltaic.jsonobject;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 联系信息属性
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GridResourceContactInfoAttrJsonObject implements Serializable {

    private static final long serialVersionUID = 5634492615383866572L;

    /**
     * 联系人/责任人
     */
    private String contacter;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 电子邮箱
     */
    private String contactEmail;

    /**
     * 传真号码
     */
    private String contactFax;

    /**
     * 负荷用户
     * 法定代表人
     */
    private String legalPerson;
}
