package com.iesms.openservices.photovoltaic.jsonobject;

import com.iesms.openservices.photovoltaic.entity.ResponsiveTimePeriod;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 弹性能力属性
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GridResourceElasticCapacityAttrJsonObject implements Serializable {

    private static final long serialVersionUID = -2259686896897367103L;

    /**
     * 响应级别（1 - 毫秒级；2 - 秒级；3 - 分钟级；4 - 小时级；5 - 日级）
     *   目前只有：2 - 秒级；3 - 分钟级；
     *   编码HEPGMS_RESPONSE_LEVEL
     */
    private Integer resLevel;

    /**
     * 响应准备时间（单位：分钟）
     */
    private Integer resReadinessTime;

    /**
     * 响应可持续时间（单位：分钟）
     */
    private Integer resDurationTime;

    /**
     * 可响应时间段
     */
    private List<ResponsiveTimePeriod> responsiveTimePeriods;
}
