package com.iesms.openservices.photovoltaic.jsonobject;

import com.iesms.openservices.photovoltaic.entity.LngLat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 地理位置属性
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GridResourceGeoLocationAttrJsonObject implements Serializable {

    private static final long serialVersionUID = 1923155870769304605L;

    /**
     * 地理位置（GEO）类型
     *  POINT   - 点
     *  LINE    - 线
     *  POLYGON - 多边形
     */
    private String geoType;

    /**
     * POINT（点）经纬度信息
     */
    private LngLat geoPoint;

    /**
     * LINE（线）经纬度信息列表
     */
    private List<LngLat> geoLine;

    /**
     * POLYGON（多边形）经纬度信息列表
     */
    private List<LngLat> geoPolygon;

    /**
     * 行政区划编码（高德地图API可获取）
     */
    private String adcode;

    /**
     * 城市编码（高德地图API可获取）
     */
    private String citycode;

    /**
     * 地址（高德地图API可获取）
     */
    private String address;
}
