package com.iesms.openservices.photovoltaic.jsonobject;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 其他基本属性
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/12
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class GridResourceOtherBasicAttrJsonObject implements Serializable {

    private static final long serialVersionUID = 6047666107175271245L;

    /**
     * 调峰电站
     * 调峰电站分类；编码HEPGMS_POWER_PLANT_ADJUSTING_PEAK_CLS
     * power_plant_adjusting_peak_class
     */
    private String powerPlantAdjustingPeakClass;

    /**
     * 调峰电站
     * 调峰电站小类；编码HEPGMS_POWER_PLANT_ADJUSTING_PEAK_SUBCLS
     * power_plant_adjusting_peak_subclass
     */
    private String powerPlantAdjustingPeakSubclass;

    /**
     * 调峰电站
     * 装机容量（单位：kW）
     *
     * 分布式电站
     * 装机容量（单位：kWp）
     */
    private BigDecimal installedCapacity;

    /**
     * 调峰电站
     * 总装机机组数
     */
    private Integer totalInstalledGensetsCount;

    /**
     * 分布式电站
     * 分布式电站分类；编码HEPGMS_POWER_PLANT_DISTRIBUTED_CLS
     * power_plant_distributed_class
     */
    private String powerPlantDistributedClass;

    /**
     * 分布式电站
     * 分布式电站小类；编码HEPGMS_POWER_PLANT_DISTRIBUTED_SUBCLS
     * power_plant_distributed_subclass
     */
    private String powerPlantDistributedSubclass;

    /**
     * 分布式电站
     * 逆变器数量
     */
    private Integer totalInvertersCount;

    /**
     * 变电站
     * 变电站分类；编码HEPGMS_NETWORK_SUBSTATION_CLS
     * network_substation_class
     */
    private String networkSubstationClass;

    /**
     * 变电站
     * 变电站小类；编码HEPGMS_NETWORK_SUBSTATION_SUBCLS
     * network_substation_subclass
     */
    private String networkSubstationSubclass;

    /**
     * 变电站
     * 变电站额定容量（单位：kVA）
     */
    private BigDecimal substationRatedCapacity;

    /**
     * 线路
     * 线路分类；编码HEPGMS_NETWORK_POWERLINE_CLS
     * network_powerline_class
     */
    private String networkPowerlineClass;

    /**
     * 线路
     * 线路小类；编码HEPGMS_NETWORK_POWERLINE_SUBCLS
     * network_powerline_subclass
     */
    private String networkPowerlineSubclass;

    /**
     * 线路
     * 线径规格；编码HEPGMS_POWERLINE_WIRE_DIAMETER_SPEC
     */
    private String powerlineWireDiameterSpec;

    /**
     * 线路
     * 材质；编码HEPGMS_POWERLINE_WIRE_MATERIAL
     */
    private String powerlineWireMaterial;

    /**
     * 线路
     * 线路限额（单位：kVA）
     */
    private BigDecimal powerlineLimitLoad;

    /**
     * 负荷用户
     * 负荷用户分类；编码HEPGMS_LOAD_CUSTOMER_CLS
     * load_customer_class
     */
    private String loadCustomerClass;

    /**
     * 负荷用户
     * 负荷用户小类；编码HEPGMS_LOAD_CUSTOMER_SUBCLS
     * load_customer_subclass
     */
    private String loadCustomerSubclass;

    /**
     * 负荷用户
     * 受电容量（单位：kVA）
     */
    private BigDecimal receivingCapacity;

    /**
     * 负荷用户
     * 立户日期（格式：yyyy-MM-dd）
     */
    private String openAccountDate;

    /**
     * 储能电站
     * 储能电站分类；编码HEPGMS_STORAGE_POWER_STATION_CLS
     * storage_power_station_class
     */
    private String storagePowerStationClass;

    /**
     * 储能电站
     * 储能电站小类；编码HEPGMS_STORAGE_POWER_STATION_SUBCLS
     * storage_power_station_subclass
     */
    private String storagePowerStationSubclass;

    /**
     * 储能电站
     * 储能总容量（单位：kWh）
     */
    private BigDecimal totalStorageCapacity;

    /**
     * 储能电站
     * 储能单元数
     */
    private Integer totalStorageUnitsCount;

    /**
     * 储能电站
     * 最大输出功率（单位：kW）
     */
    private BigDecimal maxOutputPower;

    /**
     * 可调负荷资源
     * 可调负荷资源分类；编码HEPGMS_ADJRES_LOAD_UNIT_CLS
     * adjres_load_unit_class
     */
    private String adjresLoadUnitClass;

    /**
     * 可调负荷资源
     * 可调负荷资源额定功率（单位：kW）
     */
    private BigDecimal adjresLoadUnitRatedPower;

    /**
     * 可调储能单元
     * 可调储能单元品牌厂家
     */
    private String adjresStorageUnitBrandMfrsRemark;

    /**
     * 可调储能单元
     * 可调储能单元规格型号
     */
    private String adjresStorageUnitSpecModelsRemark;
}
