package com.iesms.openservices.photovoltaic.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 大莲花首页--参数
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2022-04-07
 */
@Data
public class AgHomePageRequest implements Serializable {
    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 客户id
     */
    private String ceCustId;

    /**
     * 楼层（容器）id
     */
    private String ceCntrId;

    /**
     * 设备分类编号
     */
    private String ceResSortNo;

    /**
     * 用能资源编号
     */
    private String ceResNo;

    /**
     * 设备编号
     */
    private String devNo;

    /**
     * 区域id
     */
    private String cePartId;

    /**
     * 日期类型（1 - 日；2 - 月；3 - 年）
     */
    private String dateType;

    /**
     * 日期
     */
    private String dateStat;

    /**
     * 楼层下的房间id集合
     */
    private List<String> ceCntrIdList;

    /**
     * 绿网类型：1-降碳智慧绿网；2-温湿度绿网；3-照度绿网；4-绿色运行
     */
    private String greenNetworkType;

    /**
     * 温湿度照度类型
     * <p>
     * 11 - 室内温度
     * 12 - 室内湿度
     * 13 - 出风口温度
     * 14 - 出风口湿度
     * 21 - 室外光照强度
     * 22 - 室内光照强度
     */
    private int templuxType;

    /**
     * 事件类型
     * 1 - 光照节能事件；
     * 2 - 温湿度节能事件；
     */
    private int eventType;

    /**
     * 上级用能资源标识
     */
    private String parentCeResId;

    /**
     * 设备id
     */
    private String ceDevId;

    /**
     * 上级用能资源标识
     */
    private List<String> parentCeResIds;

    /**
     * 电量曲线日期
     */
    private String monthStat;

}
