package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 行政区域碳资产列表请求参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class CarbonAssetAdcodeRequest extends Pager {

    private static final long serialVersionUID = -7884903316336049181L;

    /**
     * 当前日期
     */
    private Date now = new Date();

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 区域编码
     */
    private String adCode;
}
