package com.iesms.openservices.photovoltaic.request;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 电站碳资产曲线查看请求参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/15
 */
@Data
public class CarbonAssetCurveRequest implements Serializable {

    private static final long serialVersionUID = -7259119824138689045L;

    /**
     * 当前日期
     */
    private Date date = new Date();

    /**
     * 收益分类
     * 1: CCER预测收益、绿证预测收益
     * 2: 绿电预测收益
     */
    private Integer earningsType = 1;

    /**
     * 资产分类
     * STATION: 电站
     * ADCODE: 行政区域
     * IMPORTANCE_CUST: 重点控排光伏用户
     */
    private String assetType = "STATION";

    /**
     * 电站标识
     */
    private Long stationId;

    /**
     * 行政区域代码
     */
    private String adcode;

    /**
     * 用户标识
     */
    private Long custId;
}
