package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 电站碳资产列表请求参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class CarbonAssetStationRequest extends Pager {

    private static final long serialVersionUID = 8318846812125284394L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 新能源投资商标识
     */
    private Long pvInvestorId;

    /**
     * 用户标识
     */
    private Long custId;
}
