package com.iesms.openservices.photovoltaic.request;

import com.iesms.openservices.photovoltaic.jsonobject.GridResourceGeoLocationAttrJsonObject;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电网资源新增或修改请求参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/13
 */
@Data
public class GridResourceInsertOrUpdateRequest implements Serializable {

    private static final long serialVersionUID = -7939514031477767862L;

    /**
     * id
     */
    private Long id;

    /**
     * 区域编码
     */
    private String adcode;

    /**
     * 父级id
     */
    private Long parentId;

    /**
     * 电网资源分类编号
     */
    private String gridResSortNo;

    /**
     * 电网资源编号
     */
    private String gridResNo;

    /**
     * 电网资源名称
     */
    private String gridResName;

    /**
     * 电压等级
     */
    private String voltageClass;

    /**
     * 投运日期
     */
    private Date gotorunDate;

    /**
     * 责任人
     */
    private String contacter;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 电网资源地址
     */
    private String gridResAddr;

    /**
     * 设计容量
     */
    private BigDecimal networkDesignCapacity;

    /**
     * 变电站的限额（装机容量）
     */
    private BigDecimal substationRatedCapacity;

    /**
     * 线路和台区的限额
     */
    private BigDecimal powerlineLimitLoad;

    /**
     * 线路
     * 线径规格；编码HEPGMS_POWERLINE_WIRE_DIAMETER_SPEC
     */
    private String powerlineWireDiameterSpec;

    /**
     * 线路
     * 材质；编码HEPGMS_POWERLINE_WIRE_MATERIAL
     */
    private String powerlineWireMaterial;

    /**
     * 设计间隔数
     */
    private Integer substationDesignIntervalCount;

    /**
     * 当前空余间隔数（单位：个）
     */
    private Integer substationSpareIntervalCount;

    /**
     * 当前空余间隔容量（单位：kVA）
     */
    private BigDecimal substationSpareIntervalCapacity;

    /**
     * 计划扩容（单位：kVA）
     */
    private BigDecimal networkPlanCapacity;

    /**
     * 高德地图地理位置属性
     */
    private GridResourceGeoLocationAttrJsonObject geoLocationAttr;
}
