package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import com.iesms.openservices.photovoltaic.entity.TmplSeOsSchemeDetail;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liumu
 * @date 2022-01-19 14:02
 * 储能运行调度方案 - 请求参数
 */
@Data
public class MgosSeOsSchemeRequest extends Pager implements Serializable {

    private static final long serialVersionUID = -2019096948463945624L;

    /**
     * 方案id
     */
    private Long id;

    private String orgNo;

    /**
     * 用能客户id
     */
    private Long ceCustId;

    /**
     * 储能电站id
     */
    private Long seStationId;

    /**
     * 模板id
     */
    private long tmplSeOsSchemeId;

    /**
     * 方案状态：1 - 初始（待投放）；2 - 已投放（待启用）；3 - 已启用；4 - 已完成（计划结束完成）；5 - 提前结束（提前结束完成）；
     */
    private Integer seOsSchemeStatus;

    /**
     * 方案名称
     */
    private String seOsSchemeName;

    /**
     * 计划开始日期
     */

    private String plannedStartDate;

    /**
     * 计划结束日期
     */
    private String plannedEndDate;

    /**
     * 实际开始时间
     */
    private String actualStartTime;

    /**
     * 方案明细
     */
    private List<TmplSeOsSchemeDetail> seOsSchemeDetail;

    /**
     * 方案模板明细Str
     */
    private String seOsSchemeDetailStr;

    /**
     * 放电上限
     */
    private BigDecimal dischargeSocLimit;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建时间
     */
    private Long gmtCreate;

    /**
     * 更新人
     */
    private String modifier;

    /**
     * 更新时间
     */
    private Long gmtModified;
}
