package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import com.iesms.openservices.photovoltaic.entity.TmplSeOsSchemeDetail;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author liumu
 * @date 2022-01-18 14:10
 * 储能运行调度方案模板请求参数
 */
@Data
public class MgosTmplSeOsSchemeRequest extends Pager implements Serializable {

    private static final long serialVersionUID = -3165564022793121010L;

    private Long id;
    private String orgNo;

    /**
     * 方案模板名称
     */
    private String tmplSeOsSchemeName;

    /**
     * 方案模板明细
     */
    private List<TmplSeOsSchemeDetail> tmplSeOsSchemeDetail;

    /**
     * 方案模板明细Str
     */
    private String tmplSeOsSchemeDetailStr;

    /**
     * 放电上限
     */
    private BigDecimal dischargeSocLimit;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 创建时间
     */
    private Long gmtCreate;

    /**
     * 更新人
     */
    private String modifier;

    /**
     * 更新时间
     */
    private Long gmtModified;
}
