package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author Lin yicheng
 * @date 2022/1/20 18:41
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class OperationalRevenueAnalysisRequest {

    /**
     * 储能站标识
     */
    private Long seStationId;

    /**
     * 统计月份 如：201903
     */
    private Long month;

    /**
     * 统计年份 如：2019
     */
    private Long year;

    /**
     * 标记位，1为月统计，2为年统计
     */
    private int code;

    /**
     * 第几页
     */
    private int current;

    /**
     * 每页多少条
     */
    private int pageSize = 10;

    /**
     * 分页
     */
    private Pager pager;

}
