package com.iesms.openservices.photovoltaic.request;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/12/2
 */
@Data
public class ParameterSettingInsertOrUpdateRequest implements Serializable {

    private static final long serialVersionUID = -3335682761932818191L;

    /**
     * 表计标识
     */
    private Long devMeterId;

    /**
     * 系统时间
     */
    private String dateTime;

    /**
     * 输出有功功率
     */
    private BigDecimal power;

    /**
     * 输出无功调解方式
     */
    private String mediationMethods;

    /**
     * 输出功率因素
     */
    private String powerFactor;

    /**
     * 输出无功功率
     */
    private BigDecimal idlePower;
}
