package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 电站发电效率分析
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/20
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PowerStationEfficiencyAnalysisMultiRequest extends Pager {

    private static final long serialVersionUID = 6673694814747361344L;

    /**
     * 当前时间
     */
    private Date now = new Date();

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 投资商标识
     */
    private Long pvInvestorId;

    /**
     * 行政区域
     */
    private String adcode;

    /**
     * 发电用户标识
     */
    private Long custId;

    /**
     * 投运年限
     * 1：一年以上
     * 2：未满一年
     */
    private Integer ageType = 1;

    /**
     * 排序方式
     */
    private String orderWay = "ASC";
}
