package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;

import java.io.Serializable;

/**
 * 分布式光伏-->运行维护--清洗记录管理
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-20
 */
@Data
public class PvStationDevCleanRecordRequest implements Serializable {

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 用户标识
     */
    private String ceCustId;

    /**
     * 设备通讯地址码
     */
    private String commonAddressNo;

    /**
     * 用能点id
     */
    private String pointId;

    /**
     * 量测点集合
     */
    private String measPointIdList;

    /**
     * 设备编号
     */
    private String devNo;

    /**
     * 设备名称
     */
    private String ceResName;

    /**
     * 开始日期
     */
    private String startTime;

    /**
     * 结束日期
     */
    private String endTime;

    /**
     * 第几页
     */
    private int current;

    /**
     * 每页多少条
     */
    private int pageSize = 10;

    /**
     * 分页
     */
    private Pager pager;
}
