package com.iesms.openservices.photovoltaic.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 分布式光伏-->运行维护--智能清洗方案设置
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-20
 */
@Data
public class PvStationDevSchemeSettingRequest implements Serializable {

    /***
     * 设备id
     */
    private String deviceId;

    /**
     * 设备通讯地址码（用于参数下发接口传参）
     */
    private String commonAddressNo;

    /***
     * 设备类型  1-双电机 2-单电机
     */
    private String robotType;

    /***
     * 策略编号  1    2
     */
    private int strategyNum;

    /***
     * 自动运行策略1--星期  1——星期一   以此类推
     */
    private int weekParam1;

    /***
     * 自动运行策略1--时间
     */
    private String dateStat1;

    /***
     * 自动运行策略1--次数
     */
    private int count1;

    /***
     * 自动运行策略--星期  1——星期一   以此类推
     */
    private int weekParam2;

    /***
     * 自动运行策略--时间
     */
    private String dateStat2;

    /***
     * 自动运行策略--次数
     */
    private int count2;

    /**
     * 电机运行速率
     */
    private String motorSpeed;

    /**
     * 反向等待时间
     */
    private String reverseWaitingTime;

    /**
     * 电机上限停机值
     */
    private String motorUpperStopValue;

    /**
     * 电机下限停机值
     */
    private String motorLowerStopValue;

    /**
     * 行走位差值
     */
    private String walkingPositionValue;

    /**
     * 保护温度
     */
    private String protectTemperature;

    /**
     * 保护电压
     */
    private String protectVoltage;

    /**
     * 保护电量
     */
    private String protectPower;
    /**
     * 限制电量
     */
    private String limitPower;

    /**
     * 恢复温度
     */
    private String recoveryTemperature;

    /**
     * 恢复电压
     */
    private String recoveryVoltage;

    /**
     * 恢复电量
     */
    private String recoveryPower;

    /**
     * 恢复电流
     */
    private String recoveryCurrent;

    /**
     * 自动下发时间
     */
    private String time;
}
