package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;

import java.io.Serializable;

/**
 * 分布式光伏-->运行维护--智能清洗设备概况
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-15
 */
@Data
public class PvStationDevSurveyRequest implements Serializable {

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 用户标识
     */
    private String ceCustId;

    /**
     * 设备标识
     */
    private String devId;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 区域编码
     */
    private String adCode;

    /**
     * 是否光伏重点项目
     */
    private String importantProject;

    /**
     * 是否有参考单元 0 - 否；1 - 是
     */
    private String isReferenceUnit;

    /**
     * 第几页
     */
    private int current;

    /**
     * 每页多少条
     */
    private int pageSize = 10;

    /**
     * 分页
     */
    private Pager pager;

}
