package com.iesms.openservices.photovoltaic.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 分布式光伏-->首页参数实体类
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-13
 */
@Data
public class PvStationMainRequest implements Serializable {

    /**
     * 运营商编号
     */
    private String orgNo;

    /**
     * 区域编码
     */
    private String adCode;

    /**
     * 建筑类型： 1 - 政党机关；2 - 公共建筑（学校、医院、村委会）；3 - 工商业厂房；4 - 农村居民屋顶
     */
    private String buildingType;

    /**
     * 并网类型：1 - 自发自用；2 - 余量上网；3 - 全额上网
     */
    private String pvNetType;

    /**
     * 电站分类：1 - 分布式光伏电站；2 - 集中式光伏电站
     */
    private String pvClassification;

    /**
     * 电站类型：1 - 屋顶电站；2 - 建筑一体化电站；3 - 渔光/农光互补电站；4 - 地面电站
     */
    private String pvType;

    /**
     * 并网电压等级：380；10000；35000
     */
    private String pvVolatageClass;

    /**
     * 用电性质（1：工商业；2：户用）
     * A – 大型专变用户；
     * B – 中小型专变用户；
     * C – 三相一般工商业用户；
     * D – 单相一般工商业用户；
     * E – 居民用户；
     * F – 公用配变；
     */
    private String consElecProp;

    /**
     * 日期时间
     */
    private String dateTime;

    /**
     * 曲线日期
     */
    private String dateStat;

    /**
     * 曲线结束日期
     */
    private String endDate;

    /**
     * 日期类型（1 - 月；2 - 年；3 - 累计）
     */
    private String dateType;

    /**
     * 电站id
     */
    private String ceCustId;

    /**
     * 曲线类型（区分月年总发电量曲线和月年总补贴金额曲线）
     */
    private String cureType;

    /**
     * 类型：1 - 查询所传日期之前的数据；2 - 查询所传日期之后的数据
     */
    private String type;

    /**
     * 用电分类
     * 1 - 高压；2 - 低压非居民；3 - 低压居民；10 - 负荷聚合商；
     */
    private String consElecSort;
}
