package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 分布式光伏-->运行维护--参考单元设置参数
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-10-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PvStationReferenceUnitSettingRequest implements Serializable {

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 用户标识
     */
    private String ceCustId;

    /**
     * 设备标识
     */
    private String deviceId;

    /**
     * 用能资源分类编号（DEV_PV_INVERTER -- 逆变器；DEV_PV_INVERTER_PVCIRCUIT -- 逆变器PV回路；DEV_PV_INVERTER_GROUPLIST -- 逆变器组串）
     */
    private String ceResSortNo;

    /**
     * 是否有参考单元
     */
    private String isReferenceUnit;

    /**
     * 第几页
     */
    private int current;

    /**
     * 每页多少条
     */
    private int pageSize = 10;

    /**
     * 分页
     */
    private Pager pager;
}
