package com.iesms.openservices.photovoltaic.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * @author Lin yicheng
 * @date 2022/4/19 15:13
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@SuperBuilder
public class PvStationReportFormRequest {

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 查询截止日期
     */
    private String date;

    /**
     * 用能客户标识
     */
    private Long ceCustId;

    /**
     * 投资模式： 1-自投资；2-代运维
     */
    private String inveModel;

    /**
     * 导出类型 0-excel，1-word
     */
    private Integer exportFlg;

}
