package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author Lin yicheng
 * @date 2022/1/18 13:28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class SchemeTrackRequest {


    /**
     * 储能站标识
     */
    private Long seStationId;

    /**
     * 方案Id
     */
    private Long schemeId;

    /**
     * 第几页
     */
    private int current;

    /**
     * 每页多少条
     */
    private int pageSize = 10;

    /**
     * 分页
     */
    private Pager pager;

    /**
     * 开始时间
     */
    private Long startTime;

    /**
     * 结束时间
     */
    private Long endTime;

    /**
     * 日期
     */
    private String Date;

    /**
     * 实际开始时间
     */
    private String actualStartTime;

    /**
     * 实际结束时间
     */
    private String actualEndTime;

}
