package com.iesms.openservices.photovoltaic.request;

import com.easesource.data.bean.Pager;
import lombok.Data;

import java.io.Serializable;

/**
 * @author liumu
 * @date 2021-11-30 10:18
 * 忠县储能 - 补贴核算数据 - 请求参数
 */
@Data
public class ZxSubsidyStatisticDataRequest implements Serializable {

    private static final long serialVersionUID = 3371381651963265012L;

    /**
     * 用能资源id
     */
    private String resourceId;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 电站用户编号（用能资编号）
     */
    private String resourceNo;

    /**
     * 电站用户名称（用能资源名称）
     */
    private String resourceName;

    /**
     * 地址（用能资源地址）
     */
    private String resourceAddr;

    /**
     * 日期类型：1-日；2-月；3-年
     */
    private Integer dateType;

    /**
     * 日期左区间
     */
    private String left;

    /**
     * 日期右区间
     */
    private String right;
}
