package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 区域光伏健康评价详细数据
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/23
 */
@Data
public class AdCodeHealthEvaluateDetailDataGetResponse implements Serializable {

    private static final long serialVersionUID = 7080280556716888057L;

    /**
     * 行政区域代码
     */
    private String adcode;

    /**
     * 行政区域名称
     */
    private String adname;

    /**
     * 电站数量
     */
    private Integer pvstationCount;

    /**
     * 装接容量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal pvTotalCapacity;

    /**
     * 实时功率
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal curValue;

    /**
     * 发电效率（未转化百分比）
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal efficiency;

    /**
     * 上个月发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEgenValueMonth;

    /**
     * 当年发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueYear;

    /**
     * 上个月利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEqHoursMonth;

    /**
     * 年利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal eqHoursYear;

    /**
     * 健康评价状态名称
     */
    private String healthEvaluateStatusName;
}
