package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 区域光伏健康评价列表数据
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/22
 */
@Data
public class AdCodeHealthEvaluateGetResponse implements Serializable {

    private static final long serialVersionUID = 2016046230804833556L;

    /**
     * 行政区域代码
     */
    private String adcode;

    /**
     * 行政区域名称
     */
    private String adname;

    /**
     * 电站数量
     */
    private Integer pvstationCount;

    /**
     * 装接容量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal pvTotalCapacity;

    /**
     * 发电效率
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal efficiency;

    /**
     * 上个月发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEgenValueMonth;

    /**
     * 上个月利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal upEqHoursMonth;

    /**
     * 当年发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueYear;

    /**
     * 年利用小时数
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal eqHoursYear;

    /**
     * 健康评价状态名称
     */
    private String healthEvaluateStatusName;
}
