package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 碳配额分析列表
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/21
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class CarbonAnalysisMultiResponse implements Serializable {

    private static final long serialVersionUID = -3432586293526921100L;

    /**
     * 月份
     */
    private Integer monthStat;

    /**
     * 当年光伏发电+当年企业用能碳排放量
     */
    private BigDecimal value;

    /**
     * 当年碳配额指标
     */
    private BigDecimal emissionQuota;

    /**
     * 碳配额消耗比例
     */
    private BigDecimal rate;
}
