package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 行政区域碳资产列表响应参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/15
 */
@Data
public class CarbonAssetAdcodeResponse implements Serializable {

    private static final long serialVersionUID = 789492450118771962L;

    /**
     * 行政区划代码
     */
    private String adcode;

    /**
     * 行政区域
     */
    private String adname;

    /**
     * 当日减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueDay;

    /**
     * 当月减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueMonth;

    /**
     * 当年减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueYear;

    /**
     * 累计减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueAccum;

    /**
     * 累计CCER预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ccerValueAccum;

    /**
     * 累计绿电预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal electricityValueAccum;

    /**
     * 累计绿证预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal evidenceValueAccum;

    /**
     * 日发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueDay;

    /**
     * 月发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueMonth;

    /**
     * 年发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueYear;

    /**
     * 累计发电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal egenValueAccum;

    /**
     * 总电站数量
     */
    private Integer pvstationCount;

    /**
     * 总装机容量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal pvTotalCapacity;
}
