package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 碳资产曲线数据
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/15
 */
@Data
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class CarbonAssetCurveResponse implements Serializable {

    private static final long serialVersionUID = -7127007497105817779L;

    /**
     * 月份
     */
    private Integer monthStat;

    /**
     * 发电量
     */
    private BigDecimal egenValueMonth;

    /**
     * 减二氧化碳排放量
     */
    private BigDecimal scdeValueMonth;

    /**
     * CCER预测收益
     */
    private BigDecimal ccerValueMonth;

    /**
     * 绿电预测收益
     */
    private BigDecimal electricityValueMonth;

    /**
     * 绿证预测收益
     */
    private BigDecimal evidenceValueMonth;
}
