package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 重点控排企业碳减排分析列表响应参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/18
 */
@Data
public class CarbonAssetCustResponse implements Serializable {

    private static final long serialVersionUID = -3425641023925531687L;

    /**
     * 用户标识
     */
    private Long id;

    /**
     * 行政区域
     */
    private String adname;

    /**
     * 用户名称
     */
    private String ceCustName;

    /**
     * 碳排放配额
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal emissionQuota;

    /**
     * 当日减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueDay;

    /**
     * 当月减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueMonth;

    /**
     * 当年减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueYear;

    /**
     * 累计CCER预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ccerValueAccum;

    /**
     * 累计绿电预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal electricityValueAccum;

    /**
     * 累计绿证预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal evidenceValueAccum;
}
