package com.iesms.openservices.photovoltaic.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.iesms.openservices.photovoltaic.common.Decimal2Serializer;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 电站碳资产列表响应参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/14
 */
@Data
public class CarbonAssetStationResponse implements Serializable {

    private static final long serialVersionUID = -4364296879973504165L;

    /**
     * 光伏电站标识
     */
    private Long id;

    /**
     * 用户编号
     */
    private String ceResNo;

    /**
     * 发电户号
     */
    private String electricityNo;


    /**
     * 投资商名称
     */
    private String investorName;

    /**
     * 发电户名
     */
    private String electricityName;

    /**
     * 用电户名
     */
    private String ceCustName;

    /**
     * 行政区域
     */
    private String adname;

    /**
     * 分公司名称
     */
    private String orgName;

    /**
     * 当日减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueDay;

    /**
     * 当月减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueMonth;

    /**
     * 当年减排量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal scdeValueYear;

    /**
     * 累计CCER预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ccerValueAccum;

    /**
     * 累计绿电预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal electricityValueAccum;

    /**
     * 累计绿证预测收益
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal evidenceValueAccum;
}
