package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 曲线天数据
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/7/13
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class CurveDayDataResponse implements Serializable {

    private static final long serialVersionUID = -6591727439889787362L;

    /**
     * 天
     */
    private Integer dateStat;

    /**
     * 发电量
     */
    private BigDecimal egenValueDay;

    /**
     * 减二氧化碳排放量
     */
    private BigDecimal scdeValueDay;

    /**
     * 月CCER预测收益
     */
    private BigDecimal ccerValueDay;

    /**
     * 绿电预测收益
     */
    private BigDecimal electricityValueDay;

    /**
     * 绿证预测收益
     */
    private BigDecimal evidenceValueDay;
}
