package com.iesms.openservices.photovoltaic.response;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 曲线月数据
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/10/22
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class CurveMonthDataResponse implements Serializable {

    private static final long serialVersionUID = 6658925436603404983L;

    /**
     * 月份
     */
    private Integer monthStat;

    /**
     * 月发电量
     */
    private BigDecimal egenValueMonth;

    /**
     * 月减二氧化碳排放量
     */
    private BigDecimal scdeValueMonth;

    /**
     * 月CCER预测收益
     */
    private BigDecimal ccerValueMonth;

    /**
     * 绿电预测收益
     */
    private BigDecimal electricityValueMonth;

    /**
     * 绿证预测收益
     */
    private BigDecimal evidenceValueMonth;

    /**
     * 月等效时数
     */
    private BigDecimal eqHoursMonth;
}
